import evs
from math import *
import evs_util

GeoLayerCellsets = [[0,1, 2, 3, 4, 5, 6, 7, 8],
    [0],
    [1],
    [2],
    [3],
    [4],
    [5],
    [6],
    [7],
    [8]]

SurfaceCellsets = [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
    [1],
    [2],
    [3],
    [4],
    [5],
    [6],
    [7],
    [8],
    [9]]

Titles = [("All Layers"),
	("Layer 1 OL"),
	("Layer 2 GP"),
	("Layer 3 SW"),
 	("Layer 4 CH"),
	("Layer 5 SM"),
	("Layer 6 CL"),
	("Layer 7 SM"),
 	("Layer 8 GP"),
 	("Layer 9 SW")]

Visibility = [("Excluded"),
    ("Visible"),
    ("Visible"),
    ("Visible"),
    ("Visible"),
    ("Visible"),
    ("Visible"),
    ("Visible"),
    ("Visible"),
    ("Visible")]

if evs.is_module_executed():
    evs.set_module('explode and scale', 'Explode And Scale Settings', 'Cell Sets', {'AutomaticallySelectEverything': False, 'SelectedIndices': GeoLayerCellsets[StateNumber]})
    evs.set_module('surfaces from horizons', 'Surface Settings', 'Surface Selection', {'AutomaticallySelectEverything': False, 'SelectedIndices': SurfaceCellsets[StateNumber]})
    evs.set_module('plume #2', 'Data Processing', 'Subsetting Level', 0.001)
    evs.set_module('Layer Titles', 'Properties', 'Title', Titles[StateNumber])
    evs.set_port('Volume Titles', 'Output Object', 'General Properties', 'Visible', Visibility[StateNumber])
    evs.set_port('Surface Area Titles', 'Output Object', 'General Properties', 'Visible', Visibility[StateNumber])
    evs.set_port('Average Thickness Titles', 'Output Object', 'General Properties', 'Visible', Visibility[StateNumber])

else: 
    evs.set_module('Layer Thicknesses Scripted Sequence', 'Sequence Options', 'State Names', ['All Layers', 'Layer 1 OL', 'Layer 2 GP', 'Layer 3 SW', 'Layer 4 CH', 'Layer 5 SM', 'Layer 6 CL', 'Layer 7 SM', 'Layer 8 GP', 'Layer 9 SW'])

# Available variables:
# NumberOfStates : Number of states total
# StateNumber    : Current state to setup
# StateName      : Name of current state
# N1 : User defined floating point number
# N2 : User defined floating point number
# N3 : User defined floating point number
# N4 : User defined floating point number
